<script src="chart/charts.js"></script>
<script src="chart/threed.js"></script>
<script src="chart/exporting.js"></script>
<script src="chart/export-data.js"></script>
<script src="chart/accessbility.js"></script>
<style>
    #salescredit {
  height: 400px; 
}

.highcharts-figure, .highcharts-data-table table {
  min-width: 310px; 
  max-width: 800px;
  margin: 1em auto;
}

.highcharts-data-table table {
  font-family: Verdana, sans-serif;
  border-collapse: collapse;
  border: 1px solid #EBEBEB;
  margin: 10px auto;
  text-align: center;
  width: 100%;
  max-width: 500px;
}
.highcharts-data-table caption {
  padding: 1em 0;
  font-size: 1.2em;
  color: green;
}
.highcharts-data-table th {
  font-weight: 600;
  padding: 0.5em;
}
.highcharts-data-table td, .highcharts-data-table th, .highcharts-data-table caption {
  padding: 0.5em;
}
.highcharts-data-table thead tr, .highcharts-data-table tr:nth-child(even) {
  background: yellow;
}
.highcharts-data-table tr:hover {
  background: orange;
}

</style>
<figure class="highcharts-figure">
    <div id="cashcredit"></div>
    
       
   
</figure>
<script>
  var dateLive = new Date().getFullYear();
   $.ajax({
      dataType: "json",
        url:'ajaxpath1/fetch_overall_cash_credit_chart.php',
        success:function(data){
           let creditData = [];
           let collectionData=[];
           data.map((list)=>{
               creditData.push(Number((((list.totalamount-list.collection)/list.totalamount)*100).toFixed(2)));
               collectionData.push(Number(((list.collection/list.totalamount)*100).toFixed(2)));
           });
        console.log(creditData);
        console.log(collectionData);
   Highcharts.chart('cashcredit', {
  colors: ['#FF6363','#FFBD69'],
    chart: {
        type: 'column',
        options3d: {
            enabled: true,
            alpha: 18,
            beta: 15,
            viewDistance: 25,
            depth: 40
        }
    },

    title: {
        text: 'Sales - Credit & Collection'
    },
    subtitle: {
        text: 'Of Year'+' '+dateLive
    },
    xAxis: {
        categories: ['jan', 'feb', 'mar', 'apr', 'may','jun', 'jul', 'aug', 'sep', 'oct','nov','dec'],
        labels: {
            skew3d: true,
            style: {
                fontSize: '16px'
            }
        }
    },

    yAxis: {
        allowDecimals: false,
        min: 0,
        title: {
            text: 'Number of fruits',
            skew3d: true
        }
    },

    tooltip: {
        headerFormat: '<b>{point.key}</b><br>',
        pointFormat: '<span style="color:{red}">\u25CF</span> {series.name}: {point.y} / {point.stackTotal}'
    },

    plotOptions: {
        column: {
            stacking: 'normal',
            depth: 40
        }
    },

    series: [ {
        name: 'Collection',
        data: collectionData,
        stack: 'male'
    },{
        name: 'Credit',
        data: creditData,
        stack: 'male'
    }]
});
        }
      });
</script>