<script src="chart/charts.js"></script>
<script src="chart/threed.js"></script>
<script src="chart/exporting.js"></script>
<script src="chart/export-data.js"></script>
<script src="chart/accessbility.js"></script>
<style>
    #monthlysales {
  height: 400px; 
}

.highcharts-figure, .highcharts-data-table table {
  min-width: 310px; 
  max-width: 800px;
  margin: 1em auto;
}

.highcharts-data-table table {
  font-family: Verdana, sans-serif;
  border-collapse: collapse;
  border: 1px solid #EBEBEB;
  margin: 10px auto;
  text-align: center;
  width: 100%;
  max-width: 500px;
}
.highcharts-data-table caption {
  padding: 1em 0;
  font-size: 1.2em;
  color: #555;
}
.highcharts-data-table th {
  font-weight: 600;
  padding: 0.5em;
}
.highcharts-data-table td, .highcharts-data-table th, .highcharts-data-table caption {
  padding: 0.5em;
}
.highcharts-data-table thead tr, .highcharts-data-table tr:nth-child(even) {
  background: #f8f8f8;
}
.highcharts-data-table tr:hover {
  background: #f1f7ff;
}

</style>
<?php 
include "financial_year_calculation.php";
$accountyear    = $financialYearStart."-".$financialYearEnd;
$year=date('Y');
$month =date('m');
$last_month=date("m",strtotime("-1 month"));
// $product_sql = "select productdetail.productname,productdetail.productcode,ifnull((select sum(netqty) from second_transaction where STATUS!='deleted' && productdetail.productcode=second_transaction.product && date between '$year-$month-01' and '$year-$month-30'),0)as total from productdetail where productdetail.status!='deleted' order by (select sum(netqty) from second_transaction where STATUS!='deleted' && productdetail.productcode=second_transaction.product && date between '$year-$month-01' and '$year-$month-30') desc limit 5 ";
$product_sql="select ifnull(sum(netqty),0) as total,productname,product from second_transaction where status!='deleted'&& date between '$year-$month-01' and '$year-$month-30' group by product order by sum(netqty) desc limit 5";
$product_sale= mysqli_query($connect,$product_sql);
while($product_code = mysqli_fetch_array($product_sale)){
?>
<input type="hidden" class="productName" value="<?php echo $product_code['productname'] ?>">
<input type="hidden" class="unitQty" value="<?php echo number_format($product_code['total'],2,'.','') ?>">
  <?php
}

?>
<figure class="highcharts-figure">
    <div id="monthlysales"></div>
    
</figure>
<script>
    var monthName=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
    var dateNumber =new Date().getMonth();
    //var MonthNumber = new Date.getMonth();
    var productName = document.querySelectorAll(".productName");
    var unitQty = document.querySelectorAll(".unitQty");
    var productArr=[];
    var qtyArr=[];
    productName.forEach((list,index)=>{
         productArr.push(list.value);
         qtyArr.push({name:list.value,data:[Number(unitQty[index].value)]});
    });
    console.log(qtyArr);
    console.log(productArr);
    Highcharts.chart('monthlysales', {
      colors: ['#41a7ab','#f0eca3','#7db5a0','#7909ad','#f5d507'],
    chart: {
        type: 'column',
        options3d: {
            enabled: true,
            alpha: 10,
            beta: 25,
            depth: 70
        }
    },
    title: {
        text: monthName[dateNumber]+' '+'Month Top 5 Product'
    },
    subtitle: {
        text: 'In Unit'
    },
    plotOptions: {
        column: {
            depth: 25
        }
    },
    xAxis: {
        categories: ['Product'],
        labels: {
            skew3d: true,
            style: {
                fontSize: '16px'
            }
        }
    },
    yAxis: {
        title: {
            text: null
        }
    },
    series: qtyArr
});
</script>