<script src="chart/charts.js"></script>
<script src="chart/threed.js"></script>
<script src="chart/exporting.js"></script>
<script src="chart/export-data.js"></script>
<script src="chart/accessbility.js"></script>
<style>
    #salescredit {
  height: 400px; 
}

.highcharts-figure, .highcharts-data-table table {
  min-width: 310px; 
  max-width: 800px;
  margin: 1em auto;
}

.highcharts-data-table table {
  font-family: Verdana, sans-serif;
  border-collapse: collapse;
  border: 1px solid #EBEBEB;
  margin: 10px auto;
  text-align: center;
  width: 100%;
  max-width: 500px;
}
.highcharts-data-table caption {
  padding: 1em 0;
  font-size: 1.2em;
  color: green;
}
.highcharts-data-table th {
  font-weight: 600;
  padding: 0.5em;
}
.highcharts-data-table td, .highcharts-data-table th, .highcharts-data-table caption {
  padding: 0.5em;
}
.highcharts-data-table thead tr, .highcharts-data-table tr:nth-child(even) {
  background: yellow;
}
.highcharts-data-table tr:hover {
  background: orange;
}

</style>
<figure class="highcharts-figure">
    <div id="overallsales"></div>
    
       
   
</figure>
<script>
    //var dateLive = new Date().getFullYear();
    $.ajax({
      dataType: "json",
        url:'ajaxpath1/fetch_overall_sales_chart.php',
        success:function(data){
            let salesData=[]
            data.map((list)=>{
                salesData.push(Number((list.weight)/1000));
            });
   Highcharts.chart('overallsales', {
      colors: ['#a60a9b'],
    chart: {
        zoomType: 'xy'
    },
    title: {
        text: 'Average Sales In Tonn of Year'+' '+dateLive
    },
    subtitle: {
        text: ''
    },
    xAxis: [{
        categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
            'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
        crosshair: true
    }],
    yAxis: [{ // Primary yAxis
        labels: {
            format: '{value}',
            style: {
                color: Highcharts.getOptions().colors[1]
            }
        },
        title: {
            text: 'Tonn',
            style: {
                color: Highcharts.getOptions().colors[1]
            }
        }
    }, { // Secondary yAxis
        title: {
            text: '',
            style: {
                color: Highcharts.getOptions().colors[0]
            }
        },
        labels: {
            format: '',
            style: {
                color: Highcharts.getOptions().colors[0]
            }
        },
        opposite: true
    }],
    tooltip: {
        shared: true
    },
    legend: {
        layout: 'vertical',
        align: 'left',
        x: 120,
        verticalAlign: 'top',
        y: 100,
        floating: true,
        backgroundColor:
            Highcharts.defaultOptions.legend.backgroundColor || // theme
            'rgba(255,255,255,0.25)'
    },
    series: [{
        name: '',
        type: 'spline',
        data: salesData,
        tooltip: {
            valueSuffix: 'Tonn'
        }
    }]
});},error:function(error){
                   console.log("error"+error.responseText);
            }
      });
</script>